package gov.va.med.mhv.admin.model;

import java.io.Serializable;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.Version;

import org.hibernate.annotations.Type;
@Entity
@Table(name="EMPLOYEE_ORG_ROLE")
public class EmployeeOrgRole implements Serializable{

	private static final long serialVersionUID = 24116501003463860L;
	
	@Id
	@Column(name="EMPLOYEE_ORG_ROLE_ID")
	@GeneratedValue(strategy=GenerationType.AUTO)
	private Long id;
	
	@Column(name="ACTIVE",columnDefinition="number")
	@Type(type="org.hibernate.type.NumericBooleanType")
	private Boolean active;
	

	@Version
	@Column(name = "OPLOCK")
	private Integer oplock;
	
	@ManyToOne
	@JoinColumn(name="EMPLOYEE_ID")
	private Employee employee;
	
	@ManyToOne
	@JoinColumn(name="ORG_ID")
	private Org organization;
	
	@ManyToOne
	@JoinColumn(name="ROLE_ID")
	private Role role;

	public Long getId() {
		return id;
	}

	public void setId(Long id) {
		this.id = id;
	}

	public Employee getEmployee() {
		return employee;
	}

	public void setEmployee(Employee employee) {
		this.employee = employee;
	}

	public Org getOrganization() {
		return organization;
	}

	public void setOrganization(Org organization) {
		this.organization = organization;
	}

	public Role getRole() {
		return role;
	}

	public void setRole(Role role) {
		this.role = role;
	}

	public Boolean getActive() {
		return active;
	}

	public void setActive(Boolean active) {
		this.active = active;
	}

	public Integer getOplock() {
		return oplock;
	}

	public void setOplock(Integer oplock) {
		this.oplock = oplock;
	}
	

}
